#ifndef _USERPROFILE_SONY_H
#define _USERPROFILE_SONY_H

#include "UnityNP.h"
#include "Mutex.h"
#include <string>

#include "../ps3/NpLookup.h"

namespace UnityPlugin
{
	// User profile structure for returning to scripts.
	struct UserProfile
	{
		int language;
		int age;
		int chatRestricted;
		int contentRestricted;
		const char* onlineID;
		const unsigned char* npID;
		int npIDSize;
		const char* avatarURL;
		const char* countryCode;
		const char *firstName;
		const char *middleName;
		const char *lastName;
		const char *profilePictureUrl;
		uint64_t npAccountId;
	};

	struct NpID
	{
		const unsigned char* npID;
		int npIDSize;
	};

	struct RemoteUserProfile
	{
		int language;
		const char* onlineID;
		const unsigned char* npID;
		int npIDSize;
		const char* avatarURL;
		const char* countryCode;
		const char *firstName;
		const char *middleName;
		const char *lastName;
		const char *profilePictureUrl;

	};


	PRX_EXPORT ErrorCode PrxRequestUserProfile();
	PRX_EXPORT bool PrxUserProfileIsBusy();
	PRX_EXPORT bool PrxGetUserProfile(UserProfile* profile);

	PRX_EXPORT ErrorCode PrxRequestRemoteUserNpID(const char* onlineID);
	PRX_EXPORT bool PrxGetRemoteUserNpID(NpID* npID);

	PRX_EXPORT ErrorCode PrxRequestRemoteUserProfileForOnlineID(const char* onlineID);
	PRX_EXPORT ErrorCode PrxRequestRemoteUserProfileForNpID(const unsigned char* npID);
	PRX_EXPORT bool PrxGetRemoteUserProfile(RemoteUserProfile* profile);

	PRX_EXPORT bool PrxUserProfileGetLastError(ResultCode* result);

	class CachedUserProfile
	{
	private:
		enum State
		{
			STATE_NOTHING,
			STATE_GETTING_LOCAL_PROFILE,
			STATE_GETTING_REMOTE_NPID,
			STATE_GETTING_REMOTE_PROFILE,
		};

		SimpleLock m_Lock;
		int m_GetCount;
		State m_State;

		std::string m_onlineID;
		std::string m_avatarURL;
		std::string m_countryCode;

		UserProfile m_profile;
		
		
		SceNpId m_npID;
		sce::Toolkit::NP::Utilities::Future<SceNpOnlineId> m_FutureOnlineID;
		sce::Toolkit::NP::Utilities::Future<SceNpId> m_FutureNpID;
		sce::Toolkit::NP::Utilities::Future<SceNpAvatarUrl> m_FutureAvatarURL;
		sce::Toolkit::NP::Utilities::Future<sce::Toolkit::NP::ParentalControlInfo> m_FutureParentInfo;
		sce::Toolkit::NP::Utilities::Future<sce::Toolkit::NP::CountryInfo> m_FutureCountryInfo;

		ResultCode m_LastResult;

		NpLookup m_NpLookup;
		SceNpId m_RemoteNpID;
		SceNpUserInfo m_RemoteUserInfo;
		SceNpAboutMe m_RemoteAboutMe;
		SceNpMyLanguages m_RemoteLanguages;
		SceNpCountryCode m_RemoteCountryCode;

	public:		
		CachedUserProfile();
		bool IsBusy();
		void GetUserProfile(UserProfile* profile);
		std::string GetOnlineID();
		bool ProcessEvent(const sce::Toolkit::NP::Event& event);
		ErrorCode RequestUserProfile();

		void Update();

		ErrorCode RequestRemoteUserNpID(const char* onlineID);
		bool GetRemoteUserNpID(NpID* npID);
		ErrorCode RequestRemoteUserProfileForOnlineID(const char* onlineID);
		ErrorCode RequestRemoteUserProfileForNpID(const unsigned char* npID);
		bool GetRemoteUserProfile(RemoteUserProfile* profile);

		SceNpId GetNpID();

		ErrorCode GetLastError() const { return m_LastResult.GetResult(); }
		bool GetLastError(ResultCode* result) const { *result = m_LastResult; return m_LastResult.GetResult() == NP_OK; }

	};

	extern CachedUserProfile gUserProfile;
}

#endif // _USERPROFILE_SONY_H
